const defaultResultPage = {
    data: [],
    maxId: null,
    minId: null,
    hitsTotal: 0,
};
export { defaultResultPage };
export { ApiErrorCode };
var ApiErrorCode;
(function (ApiErrorCode) {
    ApiErrorCode["UNAUTHORIZED"] = "E_UNAUTHORIZED";
    ApiErrorCode["INCOMPATIBLE_DRIVER"] = "E_INCOMPATIBLE_DRIVER";
    ApiErrorCode["INSTANCE_SOFTWARE_DETECTION_FAILED"] = "INSTANCE_SOFTWARE_DETECTION_FAILED";
    ApiErrorCode["DEFAULT_CLIENT"] = "E_DEFAULT_CLIENT";
    ApiErrorCode["FEATURE_UNSUPPORTED"] = "E_FEATURE_UNSUPPORTED";
    ApiErrorCode["UNKNOWN_ERROR"] = "E_UNKNOWN_ERROR";
    ApiErrorCode["OPERATION_UNSUPPORTED"] = "E_OPERATION_UNSUPPORTED";
    ApiErrorCode["REMOTE_SERVER_ERROR"] = "E_REMOTE_SERVER_ERROR";
    ApiErrorCode["INVALID_INPUT"] = "E_INVALID_INPUT";
    ApiErrorCode["PARSING_FAILED"] = "E_PARSING_FAILED";
})(ApiErrorCode || (ApiErrorCode = {}));
export function errorBuilder(error) {
    return {
        error: {
            code: error?.code || ApiErrorCode.UNKNOWN_ERROR,
        },
    };
}
export function notImplementedErrorBuilder() {
    return {
        error: {
            code: ApiErrorCode.UNKNOWN_ERROR,
        },
    };
}
//# sourceMappingURL=api-response.js.map