import * as mfm from 'mfm-js';
import HtmlParserService from './htmlparser2.js';
import ActivitypubHelper from './activitypub.js';
export { ActivitypubHelper };
export { AtprotoPostService, AtprotoFeedService } from './atproto.service.js';
export function preprocessPostContent(str) {
    str = HtmlParserService.cleanup(str);
    const ruleB = /(<a.*?>)(https:\/\/)(.*?<\/a>)/gm;
    str = str.replaceAll(ruleB, '$1$3');
    str = str.replaceAll(/<a .*?href="(.*?)".*?a>/g, '$1');
    return str;
}
export function parseStatusContent(str, log) {
    let retval = [];
    if (log)
        console.log('[INFO]: html input', str);
    str = preprocessPostContent(str);
    if (log)
        console.log('[INFO]: html cleaned', str);
    const ex = /<p>(.*?)<\/p>/g;
    if (ex.test(str)) {
        for (const item of str.match(ex) || []) {
            const exOne = /<p>(.*?)<\/p>/;
            let currStr = item.match(exOne)[1];
            const mfmTree = mfm.parse(currStr);
            retval.push(mfmTree);
        }
    }
    else {
        const mfmTree = mfm.parse(str);
        retval.push(mfmTree);
    }
    return retval;
}
//# sourceMappingURL=index.js.map