import { DomUtils, Parser } from 'htmlparser2';
import DomHandler from 'domhandler';
import DomSerializer from 'dom-serializer';
import { decode } from 'html-entities';
class HtmlParserService {
    static removeNestedSpans(node) {
        if (node.name === 'span' && node.children) {
            return node.children.flatMap(HtmlParserService.removeNestedSpans);
        }
        else if (node.children) {
            node.children = node.children.flatMap(HtmlParserService.removeNestedSpans);
        }
        return [node];
    }
    static replaceHashtagLinksWithText(node) {
        if (node.type === 'tag' && node.name === 'a') {
            const nodeData = node.children.map((o) => ({
                type: o.type,
                data: o.data,
            }));
            if (nodeData.every((o) => o.type === 'text')) {
                const text = nodeData.map((o) => o.data).join('');
                if (text.match(/#.*?/)) {
                    return DomUtils.getChildren(node);
                }
            }
        }
        if (node.children) {
            node.children = node.children.flatMap(HtmlParserService.replaceHashtagLinksWithText);
        }
        return [node];
    }
    static removeNestedEmphasis(node) {
        if (node.type === 'tag' && node.name === 'em' && node.children) {
            return node.children.flatMap(HtmlParserService.removeNestedEmphasis);
        }
        else if (node.children) {
            node.children = node.children.flatMap(HtmlParserService.removeNestedEmphasis);
        }
        return [node];
    }
    static removeLinkDecorators(node) {
        if (node.type === 'tag' && node.name === 'a') {
            delete node.attribs.rel;
            delete node.attribs.target;
            delete node.attribs.class;
        }
        if (node.children) {
            node.children = node.children.flatMap(HtmlParserService.removeLinkDecorators);
        }
        return node;
    }
    static replaceStrongTagsWithBoldTags(node) {
        if (node.type === 'tag' && node.name === 'strong') {
            node.name = 'b';
            node.tagName = 'b';
        }
        if (node.children) {
            node.children = node.children.flatMap(HtmlParserService.replaceStrongTagsWithBoldTags);
        }
        return [node];
    }
    static removeSpans(line) {
        let retval = '';
        const handler = new DomHandler((error, dom) => {
            if (error) {
            }
            else {
                const stepA = dom.flatMap(HtmlParserService.removeNestedSpans);
                retval = DomSerializer(stepA);
            }
        });
        const parser = new Parser(handler);
        parser.write(line);
        parser.end();
        return decode(retval);
    }
    static cleanup(line) {
        let retval = '';
        const handler = new DomHandler((error, dom) => {
            if (error) {
                return '[ERROR]: Dhaaga failed to parse html';
            }
            else {
                const stepA = dom.flatMap(HtmlParserService.removeNestedSpans);
                const stepB = stepA.flatMap(HtmlParserService.replaceHashtagLinksWithText);
                const stepC = stepB.flatMap(HtmlParserService.removeNestedEmphasis);
                const stepD = stepC.flatMap(HtmlParserService.replaceStrongTagsWithBoldTags);
                const stepE = stepD.flatMap(HtmlParserService.removeLinkDecorators);
                retval = DomSerializer(stepE);
                return DomSerializer(stepE);
            }
        });
        const parser = new Parser(handler);
        parser.write(line);
        parser.end();
        return decode(retval);
    }
}
export default HtmlParserService;
//# sourceMappingURL=htmlparser2.js.map