import { AtprotoApiAdapter, KNOWN_SOFTWARE } from '../index.js';
import { MisskeyApiAdapter, PleromaApiAdapter, MastoApiAdapter, } from '#/client/index.js';
class Service {
    static supportsMastoApiV1(driver) {
        return [
            KNOWN_SOFTWARE.MASTODON,
            KNOWN_SOFTWARE.PLEROMA,
            KNOWN_SOFTWARE.AKKOMA,
            KNOWN_SOFTWARE.KMYBLUE,
        ].includes(driver);
    }
    static supportsMastoApiV2(driver) {
        return [KNOWN_SOFTWARE.MASTODON].includes(driver);
    }
    static supportsMisskeyApi(driver) {
        return [
            KNOWN_SOFTWARE.MISSKEY,
            KNOWN_SOFTWARE.SHARKEY,
            KNOWN_SOFTWARE.FIREFISH,
            KNOWN_SOFTWARE.ICESHRIMP,
            KNOWN_SOFTWARE.CHERRYPICK,
            KNOWN_SOFTWARE.MEISSKEY,
        ].includes(driver);
    }
    static supportsAtProto(driver) {
        return [KNOWN_SOFTWARE.BLUESKY].includes(driver);
    }
    static supportsPleromaApi(driver) {
        return [KNOWN_SOFTWARE.PLEROMA, KNOWN_SOFTWARE.AKKOMA].includes(driver);
    }
    static canBookmark(driver) {
        return (Service.supportsMastoApiV1(driver) || Service.supportsMisskeyApi(driver));
    }
    static canLike(driver) {
        return (Service.supportsAtProto(driver) || Service.supportsMastoApiV1(driver));
    }
    static canReact(driver) {
        return (Service.supportsMisskeyApi(driver) || Service.supportsPleromaApi(driver));
    }
    static canReactMultiple(driver) {
        return Service.supportsPleromaApi(driver);
    }
    static canQuote(driver) {
        return (Service.supportsAtProto(driver) || Service.supportsMisskeyApi(driver));
    }
    static generateApiClient(software, instance, payload) {
        if (Service.supportsAtProto(software))
            return new AtprotoApiAdapter(software, instance, payload);
        if (Service.supportsMisskeyApi(software)) {
            return new MisskeyApiAdapter(software, instance, payload);
        }
        if (Service.supportsPleromaApi(software))
            return new PleromaApiAdapter(software, instance, payload);
        if (Service.supportsMastoApiV2(software))
            return new MastoApiAdapter(software, instance, payload);
        throw new Error(`Software (${software}) not supported by @dhaaga/bridge`);
    }
}
export { Service as DriverService };
//# sourceMappingURL=driver.js.map