import '../client/index.js';
import { DriverService } from './driver.js';
var KNOWN_SOFTWARE;
(function (KNOWN_SOFTWARE) {
    KNOWN_SOFTWARE["AKKOMA"] = "akkoma";
    KNOWN_SOFTWARE["BLUESKY"] = "bluesky";
    KNOWN_SOFTWARE["CHERRYPICK"] = "cherrypick";
    KNOWN_SOFTWARE["FIREFISH"] = "firefish";
    KNOWN_SOFTWARE["FRIENDICA"] = "friendica";
    KNOWN_SOFTWARE["GOTOSOCIAL"] = "gotosocial";
    KNOWN_SOFTWARE["HOMETOWN"] = "hometown";
    KNOWN_SOFTWARE["ICESHRIMP"] = "iceshrimp";
    KNOWN_SOFTWARE["KMYBLUE"] = "kmyblue";
    KNOWN_SOFTWARE["LEMMY"] = "lemmy";
    KNOWN_SOFTWARE["MASTODON"] = "mastodon";
    KNOWN_SOFTWARE["MEISSKEY"] = "meisskey";
    KNOWN_SOFTWARE["MISSKEY"] = "misskey";
    KNOWN_SOFTWARE["PEERTUBE"] = "peertube";
    KNOWN_SOFTWARE["PIXELFED"] = "pixelfed";
    KNOWN_SOFTWARE["PLEROMA"] = "pleroma";
    KNOWN_SOFTWARE["SHARKEY"] = "sharkey";
    KNOWN_SOFTWARE["UNKNOWN"] = "unknown";
})(KNOWN_SOFTWARE || (KNOWN_SOFTWARE = {}));
class ActivityPubService {
    static canBookmark(driver) {
        return DriverService.canBookmark(driver);
    }
    static canLike(driver) {
        return DriverService.canLike(driver);
    }
    static canAddReactions(driver) {
        DriverService.canReact(driver);
    }
    static mastodonLike(driver) {
        return [
            KNOWN_SOFTWARE.MASTODON,
            KNOWN_SOFTWARE.PLEROMA,
            KNOWN_SOFTWARE.AKKOMA,
        ].includes(driver);
    }
    static supportsV2(driver) {
        return DriverService.supportsMastoApiV2(driver);
    }
    static supportsQuotesNatively(driver) {
        return DriverService.canQuote(driver);
    }
    static pleromaLike(driver) {
        return [KNOWN_SOFTWARE.PLEROMA, KNOWN_SOFTWARE.AKKOMA].includes(driver);
    }
    static misskeyLike(driver) {
        return DriverService.supportsMisskeyApi(driver);
    }
    static blueskyLike(driver) {
        return DriverService.supportsAtProto(driver);
    }
    static async toggleBookmark(client, id, localState) {
        return localState ? client.posts.unBookmark(id) : client.posts.bookmark(id);
    }
    static async toggleLike(client, localState, idA, idB) {
        if (localState)
            return client.posts.removeLike(idA, idB);
        return client.posts.like(idA, idB);
    }
    static async toggleBoost(client, id, localState, domain) {
        if (DriverService.supportsMisskeyApi(domain)) {
            if (localState) {
                await client.posts.unrenote(id);
                return -1;
            }
            else {
                await client.posts.renote({
                    renoteId: id,
                    visibility: 'followers',
                    localOnly: true,
                });
                return +1;
            }
        }
        else if (DriverService.supportsMastoApiV2(domain)) {
            if (localState) {
                await client.posts.removeBoost(id);
                return -1;
            }
            else {
                await client.posts.boost(id);
                return 1;
            }
        }
        else {
            if (localState) {
                await client.posts.removeBoost(id);
                return -1;
            }
            else {
                await client.posts.boost(id);
                return +1;
            }
        }
    }
    static async getBookmarkState(client, id) {
        const data = await client.posts.getState(id);
        return data.isFavorited;
    }
}
export default ActivityPubService;
//# sourceMappingURL=activitypub.service.js.map