import { type ApiTargetInterface } from '../client/index.js';
declare enum KNOWN_SOFTWARE {
    AKKOMA = "akkoma",
    BLUESKY = "bluesky",
    CHERRYPICK = "cherrypick",
    FIREFISH = "firefish",
    FRIENDICA = "friendica",
    GOTOSOCIAL = "gotosocial",
    HOMETOWN = "hometown",
    ICESHRIMP = "iceshrimp",
    KMYBLUE = "kmyblue",
    LEMMY = "lemmy",
    MASTODON = "mastodon",
    MEISSKEY = "meisskey",
    MISSKEY = "misskey",
    PEERTUBE = "peertube",
    PIXELFED = "pixelfed",
    PLEROMA = "pleroma",
    SHARKEY = "sharkey",
    UNKNOWN = "unknown"
}
declare class ActivityPubService {
    static canBookmark(driver: KNOWN_SOFTWARE | string): boolean;
    static canLike(driver: KNOWN_SOFTWARE | string): boolean;
    static canAddReactions(driver: string): void;
    static mastodonLike(driver: string): boolean;
    static supportsV2(driver: string): boolean;
    static supportsQuotesNatively(driver: string): boolean;
    static pleromaLike(driver: string): boolean;
    static misskeyLike(driver: string): boolean;
    static blueskyLike(driver: KNOWN_SOFTWARE | string): boolean;
    static toggleBookmark(client: ApiTargetInterface, id: string, localState: boolean): Promise<import("#/index.js").DriverPostLikeState>;
    static toggleLike(client: ApiTargetInterface, localState: boolean | undefined, idA: string, idB?: string): Promise<import("#/index.js").DriverPostLikeState>;
    static toggleBoost(client: ApiTargetInterface, id: string, localState: boolean, domain: KNOWN_SOFTWARE): Promise<-1 | 1 | null>;
    static getBookmarkState(client: ApiTargetInterface, id: string): Promise<boolean | null>;
}
export default ActivityPubService;
//# sourceMappingURL=activitypub.service.d.ts.map