import { KNOWN_SOFTWARE } from '#/client/utils/driver.js';
class Mutator {
    static async toggleLike(client, input, prefs) {
        if (client.driver !== KNOWN_SOFTWARE.BLUESKY) {
            console.log('[WARN]: tried to perform feed object mutations with a non-compatible driver');
            return input;
        }
        const _client = client;
        try {
            if (!input.saved)
                return input;
            if (input.viewer.like) {
                await _client.feeds.removeLike(input.uri);
            }
            else {
                await _client.feeds.like(input.uri);
            }
            return input;
        }
        catch (e) {
            return input;
        }
    }
    static async toggleSubscription(client, input, prefs) {
        if (client.driver !== KNOWN_SOFTWARE.BLUESKY) {
            console.log('[WARN]: tried to perform feed object mutations with a non-compatible driver');
            return input;
        }
        const _client = client;
        try {
            if (input.saved) {
                await _client.feeds.removeSubscription(input.uri, prefs);
            }
            else {
                await _client.feeds.addSubscription(input.uri, prefs);
            }
            return {
                ...input,
                saved: !input.saved,
                pinned: !input.saved,
            };
        }
        catch (e) {
            return input;
        }
    }
}
export { Mutator as FeedMutator };
//# sourceMappingURL=feed.js.map