import MisskeyTag from './misskey.js';
import MastodonTag from './mastodon.js';
import DefaultTag from './default.js';
import BlueskyTag from './bluesky.js';
import { KNOWN_SOFTWARE } from '../../client/utils/driver.js';
export class MastodonTagInstance {
    instance;
    constructor(instance) {
        this.instance = instance;
    }
}
export class MisskeyTagInstance {
    instance;
    constructor(instance) {
        this.instance = instance;
    }
}
export function ActivityPubTagAdapter(tag, domain) {
    switch (domain) {
        case KNOWN_SOFTWARE.MISSKEY:
        case KNOWN_SOFTWARE.FIREFISH:
        case KNOWN_SOFTWARE.MEISSKEY:
        case KNOWN_SOFTWARE.SHARKEY:
        case KNOWN_SOFTWARE.KMYBLUE:
        case KNOWN_SOFTWARE.CHERRYPICK: {
            return new MisskeyTag(new MisskeyTagInstance(tag));
        }
        case KNOWN_SOFTWARE.MASTODON: {
            return new MastodonTag(new MastodonTagInstance(tag));
        }
        case KNOWN_SOFTWARE.BLUESKY: {
            return new BlueskyTag(tag, 'N/A');
        }
        default: {
            return new DefaultTag();
        }
    }
}
//# sourceMappingURL=_interface.js.map