import { DriveFileToMediaAttachmentAdapter } from '../media-attachment/adapter.js';
import { DriveFileInstance } from '../media-attachment/unique.js';
class MisskeyApiPostAdapter {
    ref;
    constructor(ref) {
        this.ref = ref;
    }
    getMentions = () => this.ref.mentions?.map((o) => ({
        id: o,
    })) || [];
    getReactions(myReaction) {
        const retval = [];
        const src = this.ref.reactions || {};
        for (const k in src) {
            retval.push({
                id: k,
                count: src[k],
                me: k === myReaction,
                accounts: [],
                url: null,
            });
        }
        return retval;
    }
    isReply = () => !!this.ref.replyId;
    hasParentAvailable = () => !!this.ref.reply;
    getParentRaw = () => this.ref.reply;
    isReposted = () => !!this.ref.renote;
    getReactionEmojis() {
        const retval = [];
        const _reactionEmojis = this.ref.reactionEmojis;
        if (_reactionEmojis) {
            for (const k in _reactionEmojis) {
                if (typeof _reactionEmojis[k] === 'string') {
                    retval.push({ name: k, url: _reactionEmojis[k] });
                }
                else {
                    retval.push({
                        name: _reactionEmojis[k]?.['name'],
                        url: _reactionEmojis[k]?.['url'],
                        height: _reactionEmojis[k]?.['height'],
                        width: _reactionEmojis[k]?.['width'],
                    });
                }
            }
        }
        const _emojis = this.ref.emojis;
        if (_emojis) {
            for (const k in _emojis) {
                if (typeof _emojis[k] === 'string') {
                    retval.push({ name: k, url: _emojis[k] });
                }
                else {
                    retval.push({
                        name: _emojis[k]?.['name'],
                        url: _emojis[k]?.['url'],
                        height: _emojis[k]?.['height'],
                        width: _emojis[k]?.['width'],
                    });
                }
            }
        }
        return retval;
    }
    getIsSensitive = () => !!this.ref.cw;
    getSpoilerText = () => this.ref.cw;
    getRaw = () => this?.ref;
    getIsFavourited() {
        return false;
    }
    getUser = () => this?.ref?.user;
    getParentStatusId = () => this.ref.replyId;
    getUserIdParentStatusUserId() {
        return null;
    }
    getRepostedStatusRaw = () => {
        return this.ref.renote;
    };
    getId = () => this.ref.id;
    getRepliesCount = () => this.ref.repliesCount ?? 0;
    getRepostsCount = () => this.ref.renoteCount ?? 0;
    getUsername = () => this.ref.user?.username;
    getDisplayName = () => this.ref?.user?.name;
    getAvatarUrl = () => this.ref?.user?.avatarUrl;
    getCreatedAt = () => this.ref?.createdAt || new Date().toString();
    getVisibility = () => this.ref?.visibility;
    getAccountUrl(mySubdomain) {
        if (this.ref.user?.host === undefined || this.ref.user?.host === null) {
            return `https://${mySubdomain}/@${this.ref.user?.username}`;
        }
        return `https://${this.ref.user?.host}/@${this.ref.user?.username}`;
    }
    getRepostedStatus() {
        if (this.ref?.renote !== undefined && this.ref.renote !== null) {
            return new MisskeyApiPostAdapter(this.ref?.renote);
        }
        return null;
    }
    getQuote() {
        return null;
    }
    getMediaAttachments() {
        if (!this.ref?.files) {
            return [];
        }
        return this.ref?.files.map((o) => {
            return new DriveFileToMediaAttachmentAdapter(new DriveFileInstance(o));
        });
    }
    getLinkAttachments() {
        return [];
    }
    getContent = () => this.ref?.text;
    getFacets = () => [];
    print() {
        console.log(this.ref);
    }
    getAccountId_Poster = () => this?.ref?.user?.id;
    getMyReaction = () => this.ref.myReaction;
    getCachedEmojis() {
        return new Map();
    }
    getCid() {
        return null;
    }
    getFavouritesCount() {
        return 0;
    }
    getIsBookmarked() {
        return undefined;
    }
    getIsRebloggedByMe() {
        return undefined;
    }
    getQuoteRaw() {
        return undefined;
    }
    getRootRaw() {
        return undefined;
    }
    getUri() {
        return null;
    }
    hasQuoteAvailable() {
        return false;
    }
    hasRootAvailable() {
        return false;
    }
}
export default MisskeyApiPostAdapter;
//# sourceMappingURL=misskey.js.map