import { DhaagaJsMentionObject, PostTargetInterface, Status } from './_interface.js';
import { MediaAttachmentToMediaAttachmentAdapter } from '../media-attachment/adapter.js';
import type { MastoStatus } from '../../types/mastojs.types.js';
import { PostLinkAttachmentObjectType } from '#/types/shared/link-attachments.js';
declare class MastoApiPostAdapter implements PostTargetInterface {
    ref: MastoStatus;
    constructor(ref: MastoStatus);
    getCachedEmojis(): Map<string, string>;
    getMentions(): DhaagaJsMentionObject[];
    getReactions(): {
        id: string;
        count: number;
        me: boolean;
        accounts: string[];
        url: string | null;
    }[];
    getIsRebloggedByMe(): boolean | null | undefined;
    getIsSensitive(): boolean;
    getSpoilerText(): string | null | undefined;
    getRaw: () => any;
    getIsFavourited: () => boolean | null | undefined;
    getUser: () => any;
    isReply(): boolean;
    getParentStatusId: () => string | null | undefined;
    getUserIdParentStatusUserId: () => string | null | undefined;
    getIsBookmarked: () => boolean | null | undefined;
    getId: () => string;
    getRepliesCount: () => number;
    getRepostsCount: () => number;
    getFavouritesCount: () => number;
    getUsername: () => string;
    getDisplayName: () => string;
    getAvatarUrl: () => string;
    getCreatedAt: () => string;
    getVisibility: () => keyof import("masto/mastodon/entities/v1/status.js").StatusVisibilityRegistry;
    getAccountUrl: () => any;
    getRepostedStatus(): PostTargetInterface | null;
    getQuote: () => any;
    getRepostedStatusRaw: () => any;
    isReposted: () => boolean;
    getMediaAttachments(): MediaAttachmentToMediaAttachmentAdapter[];
    getLinkAttachments(): PostLinkAttachmentObjectType[];
    getContent: () => string;
    getFacets: () => never[];
    print(): void;
    getAccountId_Poster: () => string;
    getCid(): string | null;
    getMyReaction(): string | null | undefined;
    getParentRaw(): Status;
    getQuoteRaw(): undefined | null;
    getReactionEmojis(): {
        height?: number;
        width?: number;
        name: string;
        url: string;
    }[];
    getRootRaw(): undefined | null;
    getUri(): string | null;
    hasParentAvailable(): boolean;
    hasQuoteAvailable(): boolean;
    hasRootAvailable(): boolean;
}
export default MastoApiPostAdapter;
//# sourceMappingURL=mastodon.d.ts.map