import { UserTargetInterface } from './_interface.js';
export declare class DefaultUser implements UserTargetInterface {
    getInstanceUrl(): string;
    getPinnedNotes: () => never[];
    getIsLockedProfile(): boolean | null | undefined;
    getAccountUrl(mySubdomain?: string): string;
    getAppDisplayAccountUrl(myDomain: string): string;
    getEmojiMap(): Map<string, string>;
    findEmoji(q: string): undefined;
    getAvatarBlurHash(): string;
    getAvatarUrl(): string;
    getBannerUrl(): string | null;
    getBannerBlurHash(): string | null;
    getDescription(): string | null;
    getCreatedAt(): Date;
    getBirthday(): Date | null;
    getFields(): never[];
    getFollowersCount(): number;
    getFollowingCount(): number;
    hasPendingFollowRequestFromYou(): boolean | null;
    hasPendingFollowRequestToYou(): boolean | null;
    getId(): string;
    getIsBot(): boolean;
    getDisplayName(): string | null;
    getPostCount(): number;
    getUsername(): string;
    getOnlineStatus(): 'unknown' | 'online' | 'active' | 'offline';
}
export default DefaultUser;
//# sourceMappingURL=default.d.ts.map