export class BlueskyUserInterface {
    ref;
    constructor(ref) {
        this.ref = ref;
    }
    getPinnedNotes = () => [];
    getInstanceUrl = (subdomain) => subdomain;
    getIsLockedProfile = () => false;
    extractInstanceUrl(url, username, myServer) {
        return '';
    }
    getId = () => this.ref.did;
    getDisplayName = () => this.ref.displayName;
    getAccountUrl = () => this.ref.handle;
    getAppDisplayAccountUrl = (myDomain) => this.ref.handle;
    getUsername = () => this.ref.handle;
    getAvatarUrl = () => this.ref.avatar;
    getCreatedAt = () => new Date(this.ref.createdAt || new Date());
    getEmojiMap = () => new Map();
    findEmoji(q) {
        return undefined;
    }
    isValid = () => true;
    getAvatarBlurHash = () => null;
    getBannerUrl = () => this.ref.banner;
    getBannerBlurHash = () => null;
    getDescription = () => this.ref.description;
    getBirthday = () => new Date(this.ref.createdAt || new Date());
    getFields() {
        return this.ref?.labels || [];
    }
    getFollowersCount = () => this.ref.followersCount || 0;
    getFollowingCount = () => this.ref.followsCount || 0;
    hasPendingFollowRequestFromYou = () => false;
    hasPendingFollowRequestToYou = () => false;
    getIsBot = () => false;
    getPostCount = () => this.ref.postsCount || 0;
    getOnlineStatus = () => 'unknown';
    getKnownFollowers() {
        return this.ref.viewer?.knownFollowers || [];
    }
}
export default BlueskyUserInterface;
//# sourceMappingURL=bluesky.js.map