import type { MissNote, MissUser, MissUserDetailed } from '../../types/misskey-js.types.js';
import type { MastoAccount } from '../../types/mastojs.types.js';
export type UserType = MastoAccount | MissUserDetailed | MissUser | null | undefined;
export interface UserTargetInterface {
    getAvatarBlurHash(): string | null | undefined;
    getAvatarUrl(): string | null | undefined;
    getBannerUrl(): string | null | undefined;
    getBannerBlurHash(): string | null;
    getDescription(): string | null | undefined;
    getCreatedAt(): Date;
    getBirthday(): Date | null;
    getFields(): any[];
    getFollowersCount(): number;
    getFollowingCount(): number;
    hasPendingFollowRequestFromYou(): boolean | null | undefined;
    hasPendingFollowRequestToYou(): boolean | null | undefined;
    getId(): string;
    getIsBot(): boolean | undefined | null;
    getIsLockedProfile(): boolean | undefined | null;
    getDisplayName(): string | null | undefined;
    getPostCount(): number;
    getUsername(): string;
    getInstanceUrl(subdomain?: string): string | null;
    getOnlineStatus(): 'online' | 'active' | 'offline' | 'unknown';
    getAccountUrl(mySubdomain?: string): string;
    getAppDisplayAccountUrl(myDomain: string): string;
    getEmojiMap(): Map<string, string>;
    getPinnedNotes(): MissNote[];
}
export declare class UserDetailedInstance {
    instance: MissUserDetailed;
    constructor(instance: MissUserDetailed);
}
export declare class AccountInstance {
    instance: MastoAccount;
    constructor(instance: MastoAccount);
}
export declare function ActivityPubUserAdapter(profile: any, domain: string): UserTargetInterface;
//# sourceMappingURL=_interface.d.ts.map