export class DriveFileToMediaAttachmentAdapter {
    ref;
    constructor(ref) {
        this.ref = ref;
    }
    getAltText() {
        return this.ref?.instance?.comment;
    }
    getBlurHash() {
        return this.ref?.instance?.blurhash;
    }
    getCreatedAt() {
        return this.ref?.instance?.createdAt;
    }
    getId() {
        return this.ref?.instance?.id;
    }
    getMeta() {
        return this.ref?.instance?.properties;
    }
    getName() {
        return this.ref?.instance?.name;
    }
    getPreviewUrl() {
        return this.ref?.instance?.thumbnailUrl;
    }
    getType() {
        return this.ref?.instance?.type;
    }
    getUrl() {
        return this.ref?.instance?.url;
    }
    getHeight() {
        return this.getMeta()?.height;
    }
    getWidth() {
        return this.getMeta()?.width;
    }
    print() {
        console.log(this.ref.instance);
    }
}
export class MediaAttachmentToMediaAttachmentAdapter {
    ref;
    constructor(ref) {
        this.ref = ref;
    }
    getAltText() {
        return this.ref?.instance?.description;
    }
    getBlurHash() {
        return this.ref?.instance?.blurhash;
    }
    getCreatedAt() {
        return new Date().toString();
    }
    getId() {
        return this.ref?.instance?.id;
    }
    getMeta() {
        return this.ref?.instance?.meta;
    }
    getName() {
        return this.ref?.instance?.id;
    }
    getType() {
        return this.ref?.instance?.type;
    }
    getUrl() {
        return this.ref?.instance?.remoteUrl || this.ref?.instance?.url;
    }
    getPreviewUrl() {
        return (this.ref?.instance?.previewRemoteUrl || this.ref?.instance?.previewUrl);
    }
    getHeight() {
        return this.getMeta()?.original?.height;
    }
    getWidth() {
        return this.getMeta()?.original?.width;
    }
    print() {
        console.log(this.ref.instance);
    }
}
export class UnknownToMediaAttachmentAdapter {
    ref;
    constructor(ref) {
        this.ref = ref;
    }
    getAltText() {
        return null;
    }
    getBlurHash() {
        return null;
    }
    getCreatedAt() {
        return new Date().toString();
    }
    getId() {
        return this.ref?.instance?.id;
    }
    getMeta() {
        return null;
    }
    getName() {
        return '';
    }
    getPreviewUrl() {
        return '';
    }
    getType() {
        return '';
    }
    getUrl() {
        return '';
    }
    getHeight() {
        return null;
    }
    getWidth() {
        return null;
    }
    print() {
        console.log('[WARN]: null media attachment entity');
    }
}
//# sourceMappingURL=adapter.js.map