import { z } from 'zod';
import { ApiTargetInterface } from '#/client/index.js';
import type { UserObjectType } from '#/types/index.js';
declare const DriverWebfingerSchema: z.ZodObject<{
    username: z.ZodString;
    host: z.ZodNullable<z.ZodString>;
}, z.core.$strip>;
type DriverWebfingerType = z.infer<typeof DriverWebfingerSchema>;
declare const userFindQuerySchema: z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
    use: z.ZodLiteral<"did">;
    did: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    use: z.ZodLiteral<"userId">;
    userId: z.ZodString;
}, z.core.$strip>]>, z.ZodObject<{
    use: z.ZodLiteral<"handle">;
    handle: z.ZodString;
}, z.core.$strip>]>, z.ZodObject<{
    use: z.ZodLiteral<"webfinger">;
    webfinger: z.ZodObject<{
        username: z.ZodString;
        host: z.ZodNullable<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>]>;
type DriverUserFindQueryType = z.infer<typeof userFindQuerySchema>;
export { userFindQuerySchema };
export type { DriverWebfingerType, DriverUserFindQueryType };
export declare function unifiedUserLookup(client: ApiTargetInterface, query: DriverUserFindQueryType): Promise<UserObjectType>;
//# sourceMappingURL=unifiedUserLookup.d.ts.map