var KNOWN_SOFTWARE;
(function (KNOWN_SOFTWARE) {
    KNOWN_SOFTWARE["AKKOMA"] = "akkoma";
    KNOWN_SOFTWARE["BLUESKY"] = "bluesky";
    KNOWN_SOFTWARE["CHERRYPICK"] = "cherrypick";
    KNOWN_SOFTWARE["FIREFISH"] = "firefish";
    KNOWN_SOFTWARE["FRIENDICA"] = "friendica";
    KNOWN_SOFTWARE["GOTOSOCIAL"] = "gotosocial";
    KNOWN_SOFTWARE["HOMETOWN"] = "hometown";
    KNOWN_SOFTWARE["ICESHRIMP"] = "iceshrimp";
    KNOWN_SOFTWARE["KMYBLUE"] = "kmyblue";
    KNOWN_SOFTWARE["LEMMY"] = "lemmy";
    KNOWN_SOFTWARE["MASTODON"] = "mastodon";
    KNOWN_SOFTWARE["MEISSKEY"] = "meisskey";
    KNOWN_SOFTWARE["MISSKEY"] = "misskey";
    KNOWN_SOFTWARE["PEERTUBE"] = "peertube";
    KNOWN_SOFTWARE["PIXELFED"] = "pixelfed";
    KNOWN_SOFTWARE["PLEROMA"] = "pleroma";
    KNOWN_SOFTWARE["SHARKEY"] = "sharkey";
    KNOWN_SOFTWARE["UNKNOWN"] = "unknown";
})(KNOWN_SOFTWARE || (KNOWN_SOFTWARE = {}));
const PROTOCOLS = [
    'masto_api_v1',
    'masto_api_v2',
    'misskey_api',
    'atproto',
    'pleroma_api',
];
const data = {
    [KNOWN_SOFTWARE.AKKOMA]: ['masto_api_v1'],
    [KNOWN_SOFTWARE.BLUESKY]: ['atproto'],
    [KNOWN_SOFTWARE.CHERRYPICK]: ['misskey_api'],
    [KNOWN_SOFTWARE.FIREFISH]: ['misskey_api'],
    [KNOWN_SOFTWARE.FRIENDICA]: [],
    [KNOWN_SOFTWARE.GOTOSOCIAL]: [],
    [KNOWN_SOFTWARE.HOMETOWN]: [],
    [KNOWN_SOFTWARE.ICESHRIMP]: ['misskey_api'],
    [KNOWN_SOFTWARE.KMYBLUE]: ['masto_api_v1'],
    [KNOWN_SOFTWARE.LEMMY]: [],
    [KNOWN_SOFTWARE.MASTODON]: ['masto_api_v1', 'masto_api_v2'],
    [KNOWN_SOFTWARE.MEISSKEY]: ['misskey_api'],
    [KNOWN_SOFTWARE.MISSKEY]: ['misskey_api'],
    [KNOWN_SOFTWARE.PEERTUBE]: [],
    [KNOWN_SOFTWARE.PIXELFED]: [],
    [KNOWN_SOFTWARE.PLEROMA]: ['masto_api_v1', 'pleroma_api'],
    [KNOWN_SOFTWARE.SHARKEY]: ['misskey_api'],
    [KNOWN_SOFTWARE.UNKNOWN]: [],
};
var DriverNotificationType;
(function (DriverNotificationType) {
    DriverNotificationType["CHAT"] = "chat";
    DriverNotificationType["MENTION"] = "mention";
    DriverNotificationType["HOME"] = "home";
    DriverNotificationType["PUBLIC"] = "public";
    DriverNotificationType["STATUS"] = "status";
    DriverNotificationType["REBLOG"] = "reblog";
    DriverNotificationType["FOLLOW"] = "follow";
    DriverNotificationType["FOLLOW_REQUEST"] = "follow_request";
    DriverNotificationType["FAVOURITE"] = "favourite";
    DriverNotificationType["POLL_NOTIFICATION"] = "poll";
    DriverNotificationType["STATUS_EDITED"] = "update";
    DriverNotificationType["ADMIN_SIGNUP"] = "admin.sign_up";
    DriverNotificationType["ADMIN_REPORT"] = "admin.report";
    DriverNotificationType["NOTE"] = "note";
    DriverNotificationType["REPLY"] = "reply";
    DriverNotificationType["RENOTE"] = "renote";
    DriverNotificationType["QUOTE"] = "quote";
    DriverNotificationType["REACTION"] = "reaction";
    DriverNotificationType["POLL_ENDED"] = "pollEnded";
    DriverNotificationType["FOLLOW_REQUEST_RECEIVED"] = "receiveFollowRequest";
    DriverNotificationType["FOLLOW_REQUEST_ACCEPTED"] = "followRequestAccepted";
    DriverNotificationType["ROLES_ASSIGNED"] = "roleAssigned";
    DriverNotificationType["ACHIEVEMENT_EARNED"] = "achievementEarned";
    DriverNotificationType["APP"] = "app";
    DriverNotificationType["TEST"] = "test";
    DriverNotificationType["REACTION_GROUPED"] = "reaction:grouped";
    DriverNotificationType["RENOTE_GROUPED"] = "renote:grouped";
    DriverNotificationType["POLL_VOTE"] = "pollVote";
    DriverNotificationType["GROUP_INVITED"] = "groupInvited";
})(DriverNotificationType || (DriverNotificationType = {}));
export { data, KNOWN_SOFTWARE, DriverNotificationType };
//# sourceMappingURL=driver.js.map