import FetchWrapper from './fetch.js';
import { createRestAPIClient } from 'masto';
import generator from 'megalodon';
import { KNOWN_SOFTWARE } from './driver.js';
import { api } from 'misskey-js';
export class MastoJsWrapper extends FetchWrapper {
    lib;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.lib = createRestAPIClient({
            url: this.baseUrl,
            accessToken: this.token || undefined,
        });
    }
    static create(baseUrl, token) {
        return new MastoJsWrapper(baseUrl, token);
    }
}
export class MegalodonPleromaWrapper extends FetchWrapper {
    client;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.client = generator(KNOWN_SOFTWARE.PLEROMA, this.baseUrl, this.token || undefined);
    }
    static create(baseUrl, token) {
        return new MegalodonPleromaWrapper(baseUrl, token);
    }
}
export class MegalodonGoToSocialWrapper extends FetchWrapper {
    client;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.client = generator(KNOWN_SOFTWARE.GOTOSOCIAL, this.baseUrl, this.token || undefined);
    }
    static create(baseUrl, token) {
        return new MegalodonGoToSocialWrapper(baseUrl, token);
    }
}
export class MisskeyJsWrapper extends FetchWrapper {
    client;
    constructor(baseUrl, token) {
        super(baseUrl, token);
        this.client = new api.APIClient({
            origin: this.baseUrl,
            credential: this.token || undefined,
        });
    }
    static create(baseUrl, token) {
        return new MisskeyJsWrapper(baseUrl, token);
    }
}
//# sourceMappingURL=api-wrappers.js.map