import { MastoTag, MastoTrendLink } from '#/types/mastojs.types.js';
import type { DriverNotificationType } from '#/client/utils/driver.js';
import { Endpoints } from 'misskey-js';
export type HashtagTimelineQuery = {
    limit: number;
    sinceId?: string;
    maxId?: string;
    minId?: string;
    any?: string[];
    all?: string[];
    none?: string[];
    onlyMedia?: boolean;
};
export type GetUserPostsQueryDTO = {
    limit: number;
    maxId?: string;
    excludeReplies: boolean;
};
export type GetPostsQueryDTO = {
    limit: number;
    sinceId?: string;
    minId?: string;
    maxId?: string;
};
export type GetTimelineQueryDTO = {
    limit: number;
    sinceId?: string;
    minId?: string;
    maxId?: string;
    remote?: boolean;
    local?: boolean;
    onlyMedia?: boolean;
};
export type GetTrendingDTO = {
    limit: number;
    offset?: number;
};
export type GetSearchResultQueryDTO = {
    type: 'accounts' | 'hashtags' | 'statuses' | null | undefined;
    following: boolean;
    limit: number;
    maxId?: string;
};
export type RestClientCreateDTO = {
    instance: string;
    token: string;
    clientId: number | string;
};
export type Tag = MastoTag | null | undefined;
export type TagArray = MastoTag[] | [];
export type TrendLinkArray = MastoTrendLink[] | [];
export type MediaUploadDTO = {
    readonly file: Blob | string;
    readonly description?: string | null;
    readonly focus?: string | null;
    readonly thumbnail?: Blob | string | null;
    readonly skipPolling?: boolean;
};
export type FollowPostDto = {
    reblogs: boolean;
    notify: boolean;
    languages?: string[];
    withReplies?: boolean;
};
type __MisskeyTimelineOptions = {
    limit?: number;
    sinceId?: string;
    untilId?: string;
    sinceDate?: number;
    untilDate?: number;
    allowPartial?: boolean;
    includeMyRenotes?: boolean;
    includeRenotedMyNotes?: boolean;
    includeLocalRenotes?: boolean;
    withFiles?: boolean;
    withRenotes?: boolean;
    renote?: boolean;
    poll?: boolean;
    reply?: boolean;
};
export type DhaagaJsTimelineQueryOptions = {
    limit: number;
    sinceId?: string;
    maxId?: string;
    minId?: string;
    onlyMedia?: boolean;
    remote?: boolean;
    local?: boolean;
    social?: boolean;
    any?: string[];
    all?: string[];
    none?: string[];
    pinned?: boolean | null;
    excludeReplies?: boolean | null;
    excludeReblogs?: boolean | null;
    tagged?: string | null;
    withMuted?: boolean;
} & __MisskeyTimelineOptions;
type MastoUnifiedSearchType = {
    q: string;
    following?: boolean;
    type?: 'accounts' | 'hashtags' | 'statuses';
    resolve?: boolean;
    offset?: number;
    minId?: string;
    maxId?: string;
    accountId?: string;
};
type DhaagaJsUserSearchDTO = {
    origin?: 'combined' | 'local' | 'remote';
    allowPartial?: boolean;
    limit: number;
    query: string;
    untilId?: string;
} & MastoUnifiedSearchType;
type DhaagaJsPostSearchDTO = {
    sort?: string;
    allowPartial?: true;
    filetype?: null | 'image' | 'video' | 'audio';
    limit: number;
    order?: 'asc' | 'desc';
    host?: string;
    query: string;
    userId?: null;
    sinceId?: string;
    untilId?: string;
} & MastoUnifiedSearchType;
export { DhaagaJsPostSearchDTO };
export { DhaagaJsUserSearchDTO };
export { MastoUnifiedSearchType };
export type DhaagaJsPostCreateDto = {
    inReplyToId: null | string;
    language: string;
    mediaIds: string[];
    poll?: any;
    sensitive: boolean;
    spoilerText?: string;
    status: string;
    mastoVisibility?: 'direct' | 'public' | 'unlisted' | 'private';
    misskeyVisibility?: 'public' | 'home' | 'followers' | 'specified';
    visibleUserIds?: string[];
    localOnly: boolean;
    reactionAcceptance?: null | 'likeOnly' | 'likeOnlyForRemote' | 'nonSensitiveOnly' | 'nonSensitiveOnlyForLocalLikeOnlyForRemote';
};
export type NotificationGetQueryDto = {
    limit: number;
    minId?: string;
    maxId?: string;
    accountId?: string;
    types?: DriverNotificationType[];
    excludeTypes?: DriverNotificationType[];
    markAsRead?: boolean;
    excludeType?: string[];
    includeType?: string[];
};
export type DhaagaJsMediaCreateDTO = {
    file: Blob;
    filename?: string;
    force: boolean;
    uri: string;
    name: string;
    type: string;
};
export type SubscriptionUpdateResult = Promise<{
    success: boolean;
    subscribed: boolean;
}>;
export type PinStatusUpdateResult = Promise<{
    success: boolean;
    pinned: boolean;
}>;
export type BookmarkGetQueryDTO = {
    limit: number;
    maxId?: string;
    minId?: string;
};
export type FollowerGetQueryDTO = {
    allowPartial: boolean;
    limit: number;
    id: string;
    maxId: string | null;
};
type DefaultPaginationParams = {
    readonly maxId?: string | null;
    readonly sinceId?: string | null;
    readonly minId?: string | null;
    readonly limit?: number | null;
};
type ListAccountStatusesParams = DefaultPaginationParams & {
    readonly onlyMedia?: boolean | null;
    readonly pinned?: boolean | null;
    readonly excludeReplies?: boolean | null;
    readonly excludeReblogs?: boolean | null;
    readonly tagged?: string | null;
};
export type AccountRouteStatusQueryDto = ListAccountStatusesParams & Endpoints['users/notes']['req'] & {
    bskyFilter?: 'posts_with_media';
};
export type AccountMutePostDto = {
    notifications: boolean;
    duration: number;
};
//# sourceMappingURL=typings.d.ts.map