import { PleromaInstanceRouter } from '../collections/servers/pleroma.js';
import { PleromaAccountsRouter } from '../collections/accounts/pleroma.js';
import { PleromaStatusesRouter } from '../collections/posts/pleroma.js';
import { PleromaTrendsRouter } from '../collections/trends/pleroma.js';
import { PleromaNotificationsRouter } from '../collections/notifications/pleroma.js';
import { PleromaTimelinesRouter } from '../collections/timelines/pleroma.js';
import { PleromaTagsRouter } from '../collections/tags/pleroma.js';
import { PleromaSearchRouter } from '../collections/search/pleroma.js';
import { PleromaMeRouter } from '../collections/me/pleroma.js';
import { PleromaMediaRoute } from '../collections/media/pleroma.js';
import { PleromaListsRoute } from '../collections/lists/pleroma.js';
import FetchWrapper from '../utils/fetch.js';
class Adapter {
    driver;
    server;
    key;
    fetch;
    instances;
    users;
    posts;
    trends;
    notifications;
    timelines;
    tags;
    search;
    me;
    media;
    lists;
    constructor(driver, server, dto) {
        this.driver = driver;
        this.server = server;
        this.key = dto.clientId.toString();
        this.fetch = FetchWrapper.create(dto.instance, dto.token);
        this.instances = new PleromaInstanceRouter(this.fetch);
        this.users = new PleromaAccountsRouter(this.fetch);
        this.posts = new PleromaStatusesRouter(this.fetch);
        this.trends = new PleromaTrendsRouter(this.fetch);
        this.notifications = new PleromaNotificationsRouter(this.fetch);
        this.timelines = new PleromaTimelinesRouter(this.fetch);
        this.tags = new PleromaTagsRouter(this.fetch);
        this.search = new PleromaSearchRouter(this.fetch);
        this.me = new PleromaMeRouter(this.fetch);
        this.media = new PleromaMediaRoute(this.fetch);
        this.lists = new PleromaListsRoute(this.fetch);
    }
}
export { Adapter as PleromaApiAdapter };
//# sourceMappingURL=pleroma.js.map