import { RestClientCreateDTO } from '../typings.js';
import { MisskeyInstanceRouter } from '../collections/servers/misskey.js';
import { MisskeyAccountsRouter } from '../collections/accounts/misskey.js';
import { MisskeyStatusesRouter } from '../collections/posts/misskey.js';
import { MisskeyTrendsRouter } from '../collections/trends/misskey.js';
import { MisskeyNotificationsRouter } from '../collections/notifications/misskey.js';
import { MisskeyTimelinesRouter } from '../collections/timelines/misskey.js';
import { MisskeyTagsRouter } from '../collections/tags/misskey.js';
import { MisskeySearchRouter } from '../collections/search/misskey.js';
import { MisskeyMeRouter } from '../collections/me/misskey.js';
import { MisskeyMediaRouter } from '../collections/media/misskey.js';
import { MisskeyListsRoute } from '../collections/lists/misskey.js';
import FetchWrapper from '../utils/fetch.js';
import { ApiTargetInterface } from '../index.js';
import { KNOWN_SOFTWARE } from '../utils/driver.js';
declare class Adapter implements ApiTargetInterface {
    driver: KNOWN_SOFTWARE | string;
    server: string | null;
    key: string;
    fetch: FetchWrapper;
    instances: MisskeyInstanceRouter;
    users: MisskeyAccountsRouter;
    posts: MisskeyStatusesRouter;
    trends: MisskeyTrendsRouter;
    notifications: MisskeyNotificationsRouter;
    timelines: MisskeyTimelinesRouter;
    tags: MisskeyTagsRouter;
    search: MisskeySearchRouter;
    me: MisskeyMeRouter;
    media: MisskeyMediaRouter;
    lists: MisskeyListsRoute;
    constructor(driver: KNOWN_SOFTWARE | string, server: string | null, dto: RestClientCreateDTO);
}
export { Adapter as MisskeyApiAdapter };
//# sourceMappingURL=misskey.d.ts.map