import { ApiTargetInterface } from './_interface.js';
import BlueskyAccountsRouter from '../collections/accounts/bluesky.js';
import { BlueskyInstanceRouter } from '../collections/servers/bluesky.js';
import { BlueskyListRoute } from '../collections/lists/bluesky.js';
import { BlueskyMeRouter } from '../collections/me/bluesky.js';
import BlueskyMediaRouter from '../collections/media/bluesky.js';
import BlueskyNotificationsRouter from '../collections/notifications/bluesky.js';
import BlueskyProfileRouter from '../collections/profile/bluesky.js';
import BlueskySearchRouter from '../collections/search/bluesky.js';
import BlueskyStatusesRouter from '../collections/posts/bluesky.js';
import BlueskyTagsRouter from '../collections/tags/bluesky.js';
import BlueskyTimelinesRouter from '../collections/timelines/bluesky.js';
import BlueskyTrendsRouter from '../collections/trends/bluesky.js';
import { AppAtpSessionData } from '../../types/atproto.js';
import BlueskyFeedRouter from '../collections/feeds/bluesky.js';
import { KNOWN_SOFTWARE } from '../utils/driver.js';
export type AtprotoClientCreateDTO = AppAtpSessionData;
declare class Adapter implements ApiTargetInterface {
    driver: KNOWN_SOFTWARE | string;
    server: string | null;
    key: string;
    users: BlueskyAccountsRouter;
    instances: BlueskyInstanceRouter;
    lists: BlueskyListRoute;
    me: BlueskyMeRouter;
    media: BlueskyMediaRouter;
    notifications: BlueskyNotificationsRouter;
    profile: BlueskyProfileRouter;
    search: BlueskySearchRouter;
    posts: BlueskyStatusesRouter;
    tags: BlueskyTagsRouter;
    timelines: BlueskyTimelinesRouter;
    trends: BlueskyTrendsRouter;
    feeds: BlueskyFeedRouter;
    dto: AtprotoClientCreateDTO;
    constructor(driver: KNOWN_SOFTWARE | string, server: string | null, dto: AtprotoClientCreateDTO);
    getAgent(): import("@atproto/api").AtpAgent;
}
export { Adapter as AtprotoApiAdapter };
//# sourceMappingURL=bluesky.d.ts.map