import { DefaultTimelinesRouter } from './default.js';
import { CasingUtil } from '#/utils/casing.js';
import { MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
export class PleromaTimelinesRouter extends DefaultTimelinesRouter {
    direct;
    client;
    constructor(forwarded) {
        super();
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async home(query) {
        const data = await this.client.client.getHomeTimeline(CasingUtil.snakeCaseKeys(query));
        return {
            data: data.data,
            maxId: data.data.length > 0 ? data.data[0].id : null,
        };
    }
    async public(query) {
        if (query.local === true) {
            const data = await this.client.client.getLocalTimeline(CasingUtil.snakeCaseKeys(query));
            return {
                data: data.data,
                maxId: data.data.length > 0 ? data.data[0].id : null,
            };
        }
        else {
            const data = await this.client.client.getPublicTimeline(CasingUtil.snakeCaseKeys(query));
            return {
                data: data.data,
                maxId: data.data.length > 0 ? data.data[0].id : null,
            };
        }
    }
    async bubble(query) {
        const data = await this.direct.get('/api/v1/timelines/bubble', {
            queries: CasingUtil.snakeCaseKeys(query),
        });
        return CasingUtil.camelCaseKeys(data);
    }
    async list(q, query) {
        const data = await this.client.client.getListTimeline(q, CasingUtil.snakeCaseKeys(query));
        return {
            data: data.data,
            maxId: data.data.length > 0 ? data.data[0].id : null,
        };
    }
    async hashtag(q, query) {
        const data = await this.client.client.getTagTimeline(q, CasingUtil.snakeCaseKeys(query));
        return {
            data: data.data,
            maxId: data.data.length > 0 ? data.data[0].id : null,
        };
    }
}
//# sourceMappingURL=pleroma.js.map