import { createRestAPIClient } from 'masto';
import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
export class MastodonTimelinesRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    anonLibClient(urlLike) {
        return createRestAPIClient({ url: urlLike });
    }
    async home(query) {
        const data = await this.client.lib.v1.timelines.home.list(query);
        return { data };
    }
    async public(query) {
        const data = await this.client.lib.v1.timelines.public.list(query);
        return { data };
    }
    async publicAsGuest(urlLike, query) {
        const anonLib = this.anonLibClient(urlLike);
        const data = await anonLib.v1.timelines.public.list(query);
        return { data };
    }
    async hashtag(q, query) {
        const data = await this.client.lib.v1.timelines.tag.$select(q).list(query);
        return { data };
    }
    async hashtagAsGuest(urlLike, q, query) {
        const anonLib = this.anonLibClient(urlLike);
        const data = await anonLib.v1.timelines.tag.$select(q).list(query);
        return { data };
    }
    async list(q, query) {
        const data = await this.client.lib.v1.timelines.list.$select(q).list();
        return { data };
    }
}
//# sourceMappingURL=mastodon.js.map