import { TimelinesRoute } from './_interface.js';
import { MastoStatus } from '#/types/mastojs.types.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { DhaagaJsTimelineQueryOptions } from '#/client/typings.js';
export declare class MastodonTimelinesRouter implements TimelinesRoute {
    direct: FetchWrapper;
    client: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    private anonLibClient;
    home(query: DhaagaJsTimelineQueryOptions): PaginatedPromise<MastoStatus[]>;
    public(query: DhaagaJsTimelineQueryOptions): PaginatedPromise<MastoStatus[]>;
    publicAsGuest(urlLike: string, query: DhaagaJsTimelineQueryOptions): PaginatedPromise<MastoStatus[]>;
    hashtag(q: string, query: DhaagaJsTimelineQueryOptions): PaginatedPromise<MastoStatus[]>;
    hashtagAsGuest(urlLike: string, q: string, query: DhaagaJsTimelineQueryOptions): PaginatedPromise<MastoStatus[]>;
    list(q: string, query: DhaagaJsTimelineQueryOptions): PaginatedPromise<MastoStatus[]>;
}
//# sourceMappingURL=mastodon.d.ts.map