import { getBskyAgent, getXrpcAgent } from '#/utils/atproto.js';
class BlueskyTimelinesRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    async hashtag(q, query) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.app.bsky.feed.searchPosts({
            q: q,
            limit: query.limit,
            cursor: query.maxId === null ? undefined : query.maxId,
        });
        return {
            data: data.data.posts,
            maxId: data.data.cursor,
        };
    }
    hashtagAsGuest(urlLike, q, query) {
        return Promise.resolve(undefined);
    }
    async home(query) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getTimeline({
            limit: query.limit || 10,
            cursor: query.maxId === null ? undefined : query.maxId,
        });
        return { data: data.data.feed, maxId: data.data.cursor };
    }
    list(q, query) {
        return Promise.resolve(undefined);
    }
    public(query) {
        return Promise.resolve(undefined);
    }
    publicAsGuest(urlLike, query) {
        return Promise.resolve(undefined);
    }
    async getFeed(params) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.app.bsky.feed.getFeed(params);
        return { data: data.data.feed, maxId: data.data.cursor };
    }
    async getFeedGenerator(uri) {
        const agent = getXrpcAgent(this.dto);
        return agent.app.bsky.feed.getFeedGenerator({ feed: uri });
    }
    async getFeedGenerators(uriList) {
        const agent = getXrpcAgent(this.dto);
        return agent.app.bsky.feed.getFeedGenerators({ feeds: uriList });
    }
}
export default BlueskyTimelinesRouter;
//# sourceMappingURL=bluesky.js.map