import { MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
export class PleromaTagsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async followedTags() {
        const data = await this.client.client.getFollowedTags();
        return {
            data: data.data,
        };
    }
    async follow(id) {
        const data = await this.client.client.followTag(id);
        return data.data;
    }
    async get(id) {
        const data = await this.client.client.getTag(id);
        return data.data;
    }
    async unfollow(id) {
        const data = await this.client.client.unfollowTag(id);
        return data.data;
    }
}
//# sourceMappingURL=pleroma.js.map