import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { errorBuilder } from '#/types/index.js';
import { ApiErrorCode } from '#/types/api-response.js';
export class MisskeyTagsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async followedTags() {
        throw new Error('Method not implemented.');
    }
    async follow(id) {
        return errorBuilder(ApiErrorCode.OPERATION_UNSUPPORTED);
    }
    async unfollow(id) {
        return errorBuilder(ApiErrorCode.OPERATION_UNSUPPORTED);
    }
    async get(id) {
        return this.client.client.request('hashtags/show', { tag: id });
    }
    async getTrend(id) {
        return await this.client.client.request('hashtags/trend', {
            tag: id,
        });
    }
}
//# sourceMappingURL=misskey.js.map