import { TagRoute } from './_interface.js';
import { Endpoints } from 'misskey-js';
import type { MastoTag } from '#/types/mastojs.types.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { PaginatedPromise } from '#/types/api-response.js';
export declare class MisskeyTagsRouter implements TagRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    followedTags(): PaginatedPromise<MastoTag[]>;
    follow(id: string): Promise<MastoTag>;
    unfollow(id: string): Promise<MastoTag>;
    get(id: string): Promise<Endpoints['hashtags/show']['res']>;
    getTrend(id: string): Promise<Endpoints['hashtags/trend']['res']>;
}
//# sourceMappingURL=misskey.d.ts.map