import { MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
import { CasingUtil } from '#/utils/casing.js';
export class PleromaSearchRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async findUsers(query) {
        const data = await this.client.client.search(query.q || query.query, query);
        return { data: data.data.accounts };
    }
    async findPosts(query) {
        const data = await this.client.client.search(query.q || query.query, CasingUtil.snakeCaseKeys(query));
        return { data: data.data.statuses };
    }
}
//# sourceMappingURL=pleroma.js.map