import { SearchRoute } from './_interface.js';
import { MastoAccount, MastoStatus, MastoTag } from '#/types/mastojs.types.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { DhaagaJsUserSearchDTO, MastoUnifiedSearchType } from '#/client/typings.js';
export declare class MastodonSearchRouter implements SearchRoute {
    direct: FetchWrapper;
    client: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    findUsers(query: DhaagaJsUserSearchDTO): PaginatedPromise<MastoAccount[]>;
    findPosts(query: DhaagaJsUserSearchDTO): PaginatedPromise<MastoStatus[]>;
    unifiedSearch(query: MastoUnifiedSearchType): Promise<{
        accounts: MastoAccount[];
        statuses: MastoStatus[];
        hashtags: MastoTag[];
    }>;
}
//# sourceMappingURL=mastodon.d.ts.map