import { MastoJsWrapper, MegalodonPleromaWrapper, } from '#/client/utils/api-wrappers.js';
import { CasingUtil } from '#/utils/casing.js';
import { getHumanReadableError } from '#/utils/errors.js';
export class PleromaStatusesRouter {
    direct;
    client;
    mastoClient;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
        this.mastoClient = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async getPost(id) {
        const response = await this.client.client.getStatus(id);
        return CasingUtil.camelCaseKeys(response.data);
    }
    async create(dto) {
        const response = await this.client.client.postStatus(dto.status, {
            language: dto.language,
            visibility: dto.mastoVisibility,
            in_reply_to_id: dto.inReplyToId,
            sensitive: dto.sensitive,
            spoiler_text: dto.spoilerText,
            media_ids: dto.mediaIds || [],
        });
        return CasingUtil.camelCaseKeys(response.data);
    }
    async delete(id) {
        const data = await this.client.client.deleteStatus(id);
        if (data.status === 200 || data.status === 204) {
            return { success: true, deleted: true };
        }
        return { success: false, deleted: false };
    }
    async getReactions(id) {
        const data = await this.client.client.getEmojiReactions(id);
        return CasingUtil.camelCaseKeys(data.data);
    }
    async getReactionDetails(postId, reactionId) {
        const data = await this.client.client.getEmojiReactions(postId);
        return CasingUtil.camelCaseKeys(data.data);
    }
    async addReaction(id, shortCode) {
        const data = await this.client.client.createEmojiReaction(id, shortCode);
        return CasingUtil.camelCaseKeys(data.data);
    }
    async removeReaction(id, shortCode) {
        const data = await this.client.client.deleteEmojiReaction(id, shortCode);
        return CasingUtil.camelCaseKeys(data.data);
    }
    async bookmark(id) {
        const data = await this.client.client.bookmarkStatus(id);
        return { state: data.data.bookmarked };
    }
    async unBookmark(id) {
        const data = await this.client.client.unbookmarkStatus(id);
        return { state: data.data.bookmarked };
    }
    async like(id) {
        try {
            const data = await this.client.client.favouriteStatus(id);
            return {
                state: !!data.data.favourited,
                counter: data.data.favourites_count,
            };
        }
        catch (e) {
            throw new Error(getHumanReadableError(e));
        }
    }
    async removeLike(id) {
        try {
            const data = await this.client.client.unfavouriteStatus(id);
            return {
                state: !!data.data.favourited,
                counter: data.data.favourites_count,
            };
        }
        catch (e) {
            throw new Error(getHumanReadableError(e));
        }
    }
    async getPostContext(id) {
        const data = await this.client.client.getStatusContext(id);
        return CasingUtil.camelCaseKeys(data.data);
    }
    async boost(id) {
        const data = await this.client.client.reblogStatus(id);
        return data.data;
    }
    async removeBoost(id) {
        const data = await this.client.client.unreblogStatus(id);
        return data.data;
    }
    async getLikedBy(id) {
        const data = await this.mastoClient.lib.v1.statuses
            .$select(id)
            .favouritedBy.list();
        return {
            data,
        };
    }
    async getSharedBy(id) {
        const data = await this.mastoClient.lib.v1.statuses
            .$select(id)
            .rebloggedBy.list();
        return {
            data,
        };
    }
    async getQuotedBy(id) {
        return {
            data: [],
        };
    }
}
//# sourceMappingURL=pleroma.js.map