import { StatusesRoute } from './_interface.js';
import { Endpoints } from 'misskey-js';
import FetchWrapper from '#/client/utils/fetch.js';
import type { MissContext, MissNote } from '#/types/misskey-js.types.js';
import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '#/types/driver.types.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { DhaagaJsPostCreateDto } from '#/client/typings.js';
type RenoteCreateDTO = {
    localOnly: boolean;
    renoteId: string;
    visibility: 'followers';
};
export declare class MisskeyStatusesRouter implements StatusesRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    create(dto: DhaagaJsPostCreateDto): Promise<Endpoints['notes/create']['res']>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    getPost(id: string): Promise<MissNote>;
    getReactions(postId: string): Promise<Endpoints['notes/reactions']['res']>;
    getReactionDetails(postId: string, reactionId: string): Promise<any>;
    addReaction(postId: string, reactionId: string): Promise<{
        success: true;
        reacted: true;
        id: string;
    }>;
    removeReaction(postId: string, reactionId: string): Promise<{
        success: false;
        reacted: false;
        id: string;
    }>;
    getState(id: string): Promise<Endpoints['notes/state']['res']>;
    bookmark(id: string): DriverBookmarkStateResult;
    unBookmark(id: string): DriverBookmarkStateResult;
    renotes(id: string): Promise<Endpoints['notes/renotes']['res']>;
    favourite(id: string): Promise<{
        success: boolean;
        isFavourited: true;
    }>;
    like(id: string): DriverLikeStateResult;
    removeLike(id: string): DriverLikeStateResult;
    renote(dto: RenoteCreateDTO): Promise<{
        success: true;
        renoted: true;
        post: Endpoints['notes/create']['res'];
    }>;
    unrenote(id: string): Promise<{
        success: true;
        renoted: false;
    }>;
    getPostContext(id: string, limit?: number): Promise<MissContext>;
    getLikedBy(id: string): PaginatedPromise<any>;
    getSharedBy(id: string, limit?: number): PaginatedPromise<Endpoints['notes/renotes']['res']>;
    getQuotedBy(id: string): Promise<{
        data: never[];
    }>;
}
export {};
//# sourceMappingURL=misskey.d.ts.map