import { StatusesRoute } from './_interface.js';
import { AppBskyActorDefs, AppBskyFeedDefs, AppBskyUnspeccedGetPostThreadV2, AtpSessionData, ChatBskyConvoGetConvo, ChatBskyConvoGetConvoForMembers, ChatBskyConvoSendMessage } from '@atproto/api';
import { DriverBookmarkStateResult, DriverLikeStateResult } from '#/types/driver.types.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { DhaagaJsPostCreateDto } from '#/client/typings.js';
declare class BlueskyStatusesRouter implements StatusesRoute {
    dto: AtpSessionData;
    constructor(dto: AtpSessionData);
    bookmark(id: string): DriverBookmarkStateResult;
    atProtoBookmark(uri: string, cid: string): DriverBookmarkStateResult;
    unBookmark(uri: string): DriverBookmarkStateResult;
    create(dto: DhaagaJsPostCreateDto): Promise<{
        uri: string;
        cid: string;
    }>;
    delete(id: string): Promise<{
        success: boolean;
        deleted: boolean;
    }>;
    getPost(uri: string): Promise<AppBskyFeedDefs.PostView>;
    getPosts(ids: string[]): Promise<AppBskyFeedDefs.PostView[]>;
    getPostContext(id: string, limit?: number, sort?: string): Promise<AppBskyUnspeccedGetPostThreadV2.OutputSchema>;
    like(uri: string, cid?: string): DriverLikeStateResult;
    removeLike(uri: string, cid?: string): DriverLikeStateResult;
    getConvoForMembers(members: string[]): Promise<ChatBskyConvoGetConvoForMembers.Response>;
    getConvo(id: string): Promise<ChatBskyConvoGetConvo.Response>;
    sendMessage(id: string, msg: string): Promise<ChatBskyConvoSendMessage.Response>;
    atProtoLike(uri: string, cid: string): DriverLikeStateResult;
    atProtoDeleteLike(uri: string): DriverLikeStateResult;
    atProtoRepost(uri: string, cid: string): Promise<{
        success: boolean;
        liked?: boolean;
        uri?: string;
    }>;
    atProtoDeleteRepost(uri: string): Promise<{
        success: boolean;
        liked: boolean;
    } | {
        liked?: undefined;
        success: boolean;
    }>;
    getLikedBy(id: string, limit?: number, maxId?: string): PaginatedPromise<AppBskyActorDefs.ProfileView[]>;
    getSharedBy(id: string, limit?: number, maxId?: string): PaginatedPromise<AppBskyActorDefs.ProfileView[]>;
    getQuotedBy(id: string, limit?: number, maxId?: string): PaginatedPromise<AppBskyFeedDefs.PostView[]>;
}
export default BlueskyStatusesRouter;
//# sourceMappingURL=bluesky.d.ts.map