import { CasingUtil } from '#/utils/casing.js';
import { MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
export class PleromaNotificationsRouter {
    direct;
    pleromaClient;
    constructor(forwarded) {
        this.direct = forwarded;
        this.pleromaClient = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async getAllNotifications(query) {
        const data = await this.pleromaClient.client.getNotifications(CasingUtil.snakeCaseKeys(query));
        return {
            data: data.data,
            maxId: undefined,
            minId: undefined,
        };
    }
    async getChats() {
        const data = await this.pleromaClient.client.getConversationTimeline();
        return {
            data: data.data,
        };
    }
    async getChatDetails() {
        throw new Error('method not implemented');
    }
    async getChatMessages() {
        throw new Error('method not implemented');
    }
    async getMentions(query) {
        let url = '/api/v1/notifications' +
            '?exclude_types[]=follow' +
            '&exclude_types[]=follow_request&exclude_types[]=favourite' +
            '&exclude_types[]=reblog&exclude_types[]=poll' +
            '&exclude_types[]=status&exclude_types[]=update' +
            '&exclude_types[]=admin.sign_up&exclude_types[]=admin.report' +
            '&exclude_types[]=moderation_warning' +
            '&exclude_types[]=severed_relationships' +
            '&exclude_types[]=annual_report';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        return this.direct.getCamelCaseWithLinkPagination(url);
    }
    async getSocialUpdates(query) {
        let url = '/api/v1/notifications' +
            '?exclude_types[]=follow_request' +
            '&exclude_types[]=poll' +
            '&exclude_types[]=status&exclude_types[]=update' +
            '&exclude_types[]=admin.sign_up&exclude_types[]=admin.report' +
            '&exclude_types[]=moderation_warning' +
            '&exclude_types[]=severed_relationships' +
            '&exclude_types[]=annual_report&exclude_types[]=mention';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        return this.direct.getCamelCaseWithLinkPagination(url);
    }
    async getSubscriptions(maxId) {
        let url = '/api/v1/notifications' + '?types[]=status';
        if (maxId)
            url += '&max_id=' + maxId;
        const result = await this.direct.getCamelCaseWithLinkPagination(url);
        return { data: result.data };
    }
    async sendMessage() {
        throw new Error('method not implemented');
    }
}
//# sourceMappingURL=pleroma.js.map