import { NotificationsRoute } from './_interface.js';
import { MegaConversation, MegaNotification } from '#/types/megalodon.types.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
import { MastoGroupedNotificationsResults } from '#/types/mastojs.types.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { NotificationGetQueryDto } from '#/client/typings.js';
export declare class PleromaNotificationsRouter implements NotificationsRoute {
    direct: FetchWrapper;
    pleromaClient: MegalodonPleromaWrapper;
    constructor(forwarded: FetchWrapper);
    getAllNotifications(query: NotificationGetQueryDto): PaginatedPromise<MegaNotification[]>;
    getChats(): PaginatedPromise<MegaConversation[]>;
    getChatDetails(): PaginatedPromise<any>;
    getChatMessages(): PaginatedPromise<any>;
    getMentions(query: NotificationGetQueryDto): PaginatedPromise<MastoGroupedNotificationsResults>;
    getSocialUpdates(query: NotificationGetQueryDto): Promise<{
        data: import("masto/mastodon/entities/v1/grouped-notifications.js").GroupedNotificationsResults;
        minId?: string | null | undefined;
        maxId?: string | null | undefined;
        hitsTotal?: number | undefined;
    }>;
    getSubscriptions(maxId?: string): Promise<{
        data: import("masto/mastodon/entities/v1/grouped-notifications.js").GroupedNotificationsResults;
    }>;
    sendMessage(): Promise<void>;
}
//# sourceMappingURL=pleroma.d.ts.map