import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
export class MisskeyNotificationsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async getAllNotifications(query) {
        const data = await this.client.client.request('i/notifications-grouped', query);
        return { data: data };
    }
    async getUngrouped(query) {
        const data = await this.client.client.request('i/notifications', query);
        return { data: data };
    }
    async getMentions(query) {
        const data = await this.client.client.request('notes/mentions', {
            limit: 40,
            untilId: query.maxId || undefined,
        });
        return { data: { data: data } };
    }
    async getChats(driver) {
        const data = await this.client.client.request('notes/mentions', {
            limit: 40,
            visibility: 'specified',
        });
        return { data: { data: data } };
    }
    async getChatDetails() {
        throw new Error('method not implemented');
    }
    async getChatMessages() {
        throw new Error('method not implemented');
    }
    async getSocialUpdates(query) {
        const data = await this.client.client.request('i/notifications-grouped', {
            limit: query.limit,
            untilId: query.maxId ?? undefined,
            includeTypes: [
                'follow',
                'followRequestAccepted',
                'receiveFollowRequest',
                'groupInvited',
                'reaction',
                'reaction:grouped',
                'renote',
                'renote:grouped',
            ],
            excludeTypes: ['note:grouped'],
        });
        return { data: { data: data } };
    }
    async getSubscriptions(maxId) {
        const data = await this.client.client.request('i/notifications-grouped', {
            limit: 40,
            untilId: maxId ?? undefined,
            includeTypes: ['note'],
        });
        return { data: { data: data } };
    }
    async sendMessage() {
        throw new Error('method not implemented');
    }
}
//# sourceMappingURL=misskey.js.map