import { NotificationsRoute } from './_interface.js';
import type { Endpoints } from 'misskey-js/autogen/endpoint.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { KNOWN_SOFTWARE } from '#/client/utils/driver.js';
import { PaginatedPromise } from '#/types/api-response.js';
import { NotificationGetQueryDto } from '#/client/typings.js';
export declare class MisskeyNotificationsRouter implements NotificationsRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    getAllNotifications(query: NotificationGetQueryDto): PaginatedPromise<Endpoints['i/notifications-grouped']['res']>;
    getUngrouped(query: NotificationGetQueryDto): PaginatedPromise<Endpoints['i/notifications']['res']>;
    getMentions(query: NotificationGetQueryDto): Promise<{
        data: {
            data: any;
        };
    }>;
    getChats(driver: KNOWN_SOFTWARE): Promise<{
        data: {
            data: any;
        };
    }>;
    getChatDetails(): PaginatedPromise<any>;
    getChatMessages(): PaginatedPromise<any>;
    getSocialUpdates(query: NotificationGetQueryDto): Promise<{
        data: {
            data: any;
        };
    }>;
    getSubscriptions(maxId?: string): Promise<{
        data: {
            data: any;
        };
    }>;
    sendMessage(): Promise<void>;
}
//# sourceMappingURL=misskey.d.ts.map