import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
export class MastodonNotificationsRouter {
    direct;
    mastoClient;
    constructor(forwarded) {
        this.direct = forwarded;
        this.mastoClient = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async getAllNotifications(query) {
        const { excludeTypes, types, ...rest } = query;
        if (types && types.length > 0) {
            rest['types[]'] = types.join(';');
        }
        return this.direct.getCamelCaseWithLinkPagination('/api/v1/notifications', rest);
    }
    async getMentions(query) {
        let url = '/api/v2/notifications' +
            '?exclude_types[]=follow' +
            '&exclude_types[]=follow_request&exclude_types[]=favourite' +
            '&exclude_types[]=reblog&exclude_types[]=poll' +
            '&exclude_types[]=status&exclude_types[]=update' +
            '&exclude_types[]=admin.sign_up&exclude_types[]=admin.report' +
            '&exclude_types[]=moderation_warning' +
            '&exclude_types[]=severed_relationships' +
            '&exclude_types[]=annual_report';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        return this.direct.getCamelCaseWithLinkPagination(url);
    }
    async getSocialUpdates(query) {
        let url = '/api/v2/notifications' +
            '?grouped_types[]=reblog' +
            '&grouped_types[]=follow&exclude_types[]=follow_request' +
            '&exclude_types[]=poll' +
            '&exclude_types[]=status&exclude_types[]=update' +
            '&exclude_types[]=admin.sign_up&exclude_types[]=admin.report' +
            '&exclude_types[]=moderation_warning' +
            '&exclude_types[]=severed_relationships' +
            '&exclude_types[]=annual_report&exclude_types[]=mention';
        if (query.limit)
            url += '&limit=' + query.limit;
        if (query.maxId)
            url += '&max_id=' + query.maxId;
        return this.direct.getCamelCaseWithLinkPagination(url);
    }
    async getSubscriptions(maxId) {
        let url = '/api/v2/notifications' + '?types[]=status';
        if (maxId)
            url += '&max_id=' + maxId;
        return this.direct.getCamelCaseWithLinkPagination(url);
    }
    async getChats() {
        const data = await this.mastoClient.lib.v1.conversations.list();
        return {
            data,
        };
    }
    async getChatDetails() {
        throw new Error('method not implemented');
    }
    async getChatMessages() {
        throw new Error('method not implemented');
    }
    async markChatAsRead(id) {
        return await this.mastoClient.lib.v1.conversations.$select(id).read();
    }
    async markChatAsUnread(id) {
        return await this.mastoClient.lib.v1.conversations.$select(id).unread();
    }
    async markChatRemove(id) {
        return await this.mastoClient.lib.v1.conversations.$select(id).remove();
    }
    async sendMessage() {
        throw new Error('method not implemented');
    }
}
//# sourceMappingURL=mastodon.js.map