import { getBskyAgent, getXrpcAgent } from '#/utils/atproto.js';
class BlueskyNotificationsRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    async getAllNotifications(query) {
        const agent = getXrpcAgent(this.dto);
        const response = await agent.listNotifications({ limit: query.limit });
        return {
            data: response.data.notifications,
            maxId: response.data.cursor,
        };
    }
    async getChats() {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.chat.bsky.convo.listConvos({ limit: 20 }, { headers: { 'Atproto-Proxy': 'did:web:api.bsky.chat#bsky_chat' } });
        return {
            data: data.data.convos,
            maxId: data.data.cursor,
        };
    }
    async getChatDetails(convoId) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.chat.bsky.convo.getConvo({ convoId }, {
            headers: {
                'Atproto-Proxy': 'did:web:api.bsky.chat#bsky_chat',
            },
        });
        return data.data.convo;
    }
    async getChatMessages(convoId) {
        const agent = getXrpcAgent(this.dto);
        const data = await agent.chat.bsky.convo.getMessages({ convoId, limit: 60 }, {
            headers: {
                'Atproto-Proxy': 'did:web:api.bsky.chat#bsky_chat',
            },
        });
        return {
            data: data.data.messages,
            maxId: data.data.cursor,
        };
    }
    async getMentions() {
        const agent = getBskyAgent(this.dto);
        const response = await agent.listNotifications({
            reasons: ['mention', 'reply', 'quote'],
            limit: 30,
        });
        return {
            data: response.data.notifications,
            maxId: response.data.cursor,
        };
    }
    async getSubscriptions() {
        const agent = getBskyAgent(this.dto);
        const response = await agent.listNotifications({
            reasons: ['subscribed-post'],
            limit: 40,
        });
        return {
            data: response.data.notifications,
            maxId: response.data.cursor,
        };
    }
    async sendMessage(convoId, content) {
        const agent = getXrpcAgent(this.dto);
        const response = await agent.chat.bsky.convo.sendMessage({
            convoId,
            message: { text: content.text, facets: content.facets },
        }, {
            headers: {
                'Atproto-Proxy': 'did:web:api.bsky.chat#bsky_chat',
            },
        });
        return response.data;
    }
    async getSocialUpdates(query) {
        const agent = getBskyAgent(this.dto);
        const resp = await agent.listNotifications({
            reasons: ['like', 'follow', 'repost'],
        });
        return {
            data: resp.data.notifications,
            maxId: resp.data.cursor,
        };
    }
}
export default BlueskyNotificationsRouter;
//# sourceMappingURL=bluesky.js.map