import { MegalodonPleromaWrapper } from '#/client/utils/api-wrappers.js';
import { CasingUtil } from '#/utils/casing.js';
export class PleromaMediaRoute {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MegalodonPleromaWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async create(dto) {
        return this.client.client.uploadMedia(dto.file);
    }
    async updateDescription(id, text) {
        const data = await this.client.client.updateMedia(id, {
            description: text,
        });
        if (data.status !== 200)
            throw new Error(data.statusText);
        return { data: CasingUtil.camelCaseKeys(data.data) };
    }
}
//# sourceMappingURL=pleroma.js.map