import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { getHumanReadableError } from '#/utils/errors.js';
export class MisskeyMediaRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async create(dto) {
        const formData = new FormData();
        formData.append('file', dto.file);
        const data = await this.client.client.request('drive/files/create', formData);
        return data;
    }
    async updateDescription(id, text) {
        try {
            const data = await this.client.client.request('drive/files/update', {
                fileId: id,
                comment: text,
            });
            return { data };
        }
        catch (e) {
            throw new Error(getHumanReadableError(e));
        }
    }
}
//# sourceMappingURL=misskey.js.map