import { MediaRoute } from './_interface.js';
import { Endpoints } from 'misskey-js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { DhaagaJsMediaCreateDTO } from '#/client/typings.js';
export declare class MisskeyMediaRouter implements MediaRoute {
    direct: FetchWrapper;
    client: MisskeyJsWrapper;
    constructor(forwarded: FetchWrapper);
    create(dto: DhaagaJsMediaCreateDTO): Promise<Endpoints['drive/files/create']['res']>;
    updateDescription(id: string, text: string): Promise<{
        data: {
            id: string;
            createdAt: string;
            name: string;
            type: string;
            md5: string;
            size: number;
            isSensitive: boolean;
            blurhash: string | null;
            properties: {
                width?: number | undefined;
                height?: number | undefined;
                orientation?: number | undefined;
                avgColor?: string | undefined;
            };
            url: string;
            thumbnailUrl: string | null;
            comment: string | null;
            folderId: string | null;
            folder?: {
                id: string;
                createdAt: string;
                name: string;
                parentId: string | null;
                foldersCount?: number | undefined;
                filesCount?: number | undefined;
                parent?: any | null | undefined;
            } | null | undefined;
            userId: string | null;
            user?: {
                id: string;
                name: string | null;
                username: string;
                host: string | null;
                avatarUrl: string;
                avatarBlurhash: string | null;
                avatarDecorations: {
                    id: string;
                    angle?: number | undefined;
                    flipH?: boolean | undefined;
                    url: string;
                    offsetX?: number | undefined;
                    offsetY?: number | undefined;
                }[];
                isBot?: boolean | undefined;
                isCat?: boolean | undefined;
                requireSigninToViewContents?: boolean | undefined;
                makeNotesFollowersOnlyBefore?: number | null | undefined;
                makeNotesHiddenBefore?: number | null | undefined;
                instance?: {
                    name: string | null;
                    softwareName: string | null;
                    softwareVersion: string | null;
                    iconUrl: string | null;
                    faviconUrl: string | null;
                    themeColor: string | null;
                } | undefined;
                emojis: {
                    [key: string]: string;
                };
                onlineStatus: "active" | "offline" | "online" | "unknown";
                badgeRoles?: {
                    name: string;
                    iconUrl: string | null;
                    displayOrder: number;
                }[] | undefined;
            } | null | undefined;
        };
    }>;
}
//# sourceMappingURL=misskey.d.ts.map