import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
export class MastodonMediaRoute {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MastoJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async create(dto) {
        const fd = new FormData();
        fd.append('file', dto.uri);
        const data = await fetch('https://mastodon.social/api/v1/media', {
            method: 'POST',
            body: fd,
            headers: {
                'Content-Type': 'multipart/form-data',
                Authorization: `Bearer ${this.direct.token}`,
            },
        }).then((res) => {
            if (res.ok) {
                console.log('lgtm');
            }
            else {
                console.log(res.statusText, res.status);
            }
        });
        console.log(data);
        return await this.client.lib.v2.media.create({
            file: dto.uri,
            thumbnail: dto.uri,
        });
    }
    async updateDescription(id, text) {
        const data = await this.client.lib.v1.media.$select(id).update({
            description: text,
        });
        return { data };
    }
}
//# sourceMappingURL=mastodon.js.map