import { getBskyAgent, getXrpcAgent } from '#/utils/atproto.js';
export class BlueskyMeRouter {
    dto;
    xrpc;
    constructor(dto) {
        this.dto = dto;
        this.xrpc = getXrpcAgent(this.dto);
    }
    async getMe() {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getProfile({ actor: this.dto.did });
        return data.data;
    }
    async getPreferences() {
        const data = await this.xrpc.app.bsky.actor.getPreferences();
        return data.data;
    }
    async getSession() {
        const data = await this.xrpc.com.atproto.server.getSession();
        return data.data;
    }
}
//# sourceMappingURL=bluesky.js.map