import { MisskeyJsWrapper } from '#/client/utils/api-wrappers.js';
import { errorBuilder } from '#/types/index.js';
import { ApiErrorCode } from '#/types/api-response.js';
export class MisskeyAccountsRouter {
    direct;
    client;
    constructor(forwarded) {
        this.direct = forwarded;
        this.client = MisskeyJsWrapper.create(forwarded.baseUrl, forwarded.token);
    }
    async getPosts(id, query) {
        const data = await this.client.client.request('users/notes', {
            ...query,
            withFiles: !!query.onlyMedia ? query.onlyMedia : undefined,
        });
        return {
            data,
            maxId: data.length > 0 ? data[data.length - 1].id : null,
            minId: data.length > 0 ? data[0].id : null,
        };
    }
    async relationships(ids) {
        throw new Error('method not implemented');
    }
    async get(id) {
        return this.client.client.request('users/show', {
            userId: id,
        });
    }
    async resolveMany(ids) {
        return this.client.client.request('users/show', {
            userIds: ids,
        });
    }
    async follow(id, opts) {
        try {
            return this.client.client.request('following/create', {
                userId: id,
                ...opts,
            });
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
    async unfollow(id) {
        try {
            return this.client.client.request('following/delete', {
                userId: id,
            });
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
    async block(id) {
        try {
            return this.client.client.request('blocking/create', {
                userId: id,
            });
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
    async unblock(id) {
        try {
            return await this.client.client.request('blocking/delete', {
                userId: id,
            });
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
    async findByWebfinger({ username, host, }) {
        try {
            const data = await this.client.client.request('users/show', {
                username,
                host,
            });
            return { data };
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
    async findByUserId(id) {
        try {
            const data = await this.client.client.request('users/show', {
                userId: id,
            });
            return { data };
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
    async findByUserIds(ids) {
        if (ids.length === 0)
            return { data: [] };
        try {
            const data = await this.client.client.request('users/show', {
                userIds: ids,
            });
            return { data };
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
    async renoteMute(id) {
        await this.client.client.request('renote-mute/create', {
            userId: id,
        });
        return { renoteMuted: true };
    }
    async renoteUnmute(id) {
        await this.client.client.request('renote-mute/delete', {
            userId: id,
        });
        return { renoteMuted: false };
    }
    async likes(query) {
        return errorBuilder(ApiErrorCode.FEATURE_UNSUPPORTED);
    }
    async bookmarks(query) {
        try {
            const data = await this.direct.post('/api/i/favorites', {
                limit: query.limit,
                untilId: !!query.maxId ? query.maxId : undefined,
            }, {});
            let maxId = null;
            let minId = null;
            if (data.length > 0) {
                maxId = data[data.length - 1].id;
                minId = data[0].id;
            }
            return {
                data: data.map((o) => o.note),
                maxId,
                minId,
            };
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
    async getFollowers(query) {
        const data = await this.client.client.request('users/followers', {
            allowPartial: true,
            limit: query.limit,
            userId: query.id,
            untilId: !!query.maxId ? query.maxId : undefined,
        });
        return {
            data: data.map((o) => o.follower),
            maxId: data.length > 0 ? data[data.length - 1].followerId : null,
        };
    }
    async getFollowings(query) {
        const data = await this.client.client.request('users/following', {
            allowPartial: true,
            limit: query.limit,
            userId: query.id,
            untilId: !!query.maxId ? query.maxId : undefined,
        });
        return {
            data: data.map((o) => o.followee),
            maxId: data.length > 0 ? data[data.length - 1].followerId : null,
        };
    }
    async mute() { }
    async unmute() { }
    async removeFollower() { }
    async lookup() { }
    async featuredTags(id) {
        throw new Error('method unsupported by driver');
    }
    async knownFollowers(ids) {
        throw new Error('method unsupported by driver');
    }
    async getLists() {
        try {
            const data = await this.client.client.request('users/lists/list', {});
            return {
                data,
                maxId: data.length > 0 ? data[data.length - 1].id : null,
            };
        }
        catch (e) {
            throw new Error(e.code ?? e);
        }
    }
}
//# sourceMappingURL=misskey.js.map