import { AccountRoute } from './_interface.js';
import { AccountMutePostDto, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO, FollowPostDto, GetPostsQueryDTO } from '../../typings.js';
import FetchWrapper from '#/client/utils/fetch.js';
import { MastoAccount, MastoFamiliarFollowers, MastoFeaturedTag, MastoList, MastoRelationship, MastoStatus } from '#/types/mastojs.types.js';
import { MastoJsWrapper } from '#/client/utils/api-wrappers.js';
import { DriverWebfingerType } from '#/types/query.types.js';
import { PaginatedPromise } from '#/types/api-response.js';
export declare class MastodonAccountsRouter implements AccountRoute {
    direct: FetchWrapper;
    client: MastoJsWrapper;
    constructor(forwarded: FetchWrapper);
    lookup(webfinger: DriverWebfingerType): Promise<MastoAccount>;
    follow(id: string, opts: FollowPostDto): Promise<MastoRelationship>;
    unfollow(id: string): Promise<MastoRelationship>;
    block(id: string): Promise<MastoRelationship>;
    unblock(id: string): Promise<MastoRelationship>;
    mute(id: string, opts: AccountMutePostDto): Promise<MastoRelationship>;
    unmute(id: string): Promise<MastoRelationship>;
    removeFollower(id: string): Promise<void>;
    featuredTags(id: string): Promise<MastoFeaturedTag[]>;
    knownFollowers(ids: string[]): Promise<MastoFamiliarFollowers[]>;
    getLists(id: string): PaginatedPromise<MastoList[]>;
    getPosts(id: string, query: AccountRouteStatusQueryDto): PaginatedPromise<MastoStatus[]>;
    get(id: string): Promise<MastoAccount>;
    resolveMany(ids: string[]): Promise<MastoAccount[]>;
    relationships(ids: string[]): Promise<MastoRelationship[]>;
    likes(query: GetPostsQueryDTO): PaginatedPromise<MastoStatus[]>;
    bookmarks(query: BookmarkGetQueryDTO): PaginatedPromise<MastoStatus[]>;
    getFollowers(query: FollowerGetQueryDTO): PaginatedPromise<MastoAccount[]>;
    getFollowings(query: FollowerGetQueryDTO): PaginatedPromise<MastoAccount[]>;
}
//# sourceMappingURL=mastodon.d.ts.map