import { AccountRoute } from './_interface.js';
import { AccountMutePostDto, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO, FollowPostDto, GetPostsQueryDTO } from '../../typings.js';
import { Endpoints } from 'misskey-js';
import { MastoAccount, MastoFamiliarFollowers, MastoFeaturedTag, MastoList, MastoRelationship, MastoStatus } from '#/types/mastojs.types.js';
import { MegaAccount, MegaRelationship, MegaStatus } from '#/types/megalodon.types.js';
import { MissUserDetailed } from '#/types/misskey-js.types.js';
import { DriverWebfingerType } from '#/types/query.types.js';
import { PaginatedPromise } from '#/types/api-response.js';
export declare abstract class BaseAccountsRouter implements AccountRoute {
    lookup(webfinger: DriverWebfingerType): Promise<MastoAccount | MegaAccount>;
    follow(id: string, opts: FollowPostDto): Promise<MastoRelationship | Endpoints['following/create']['res'] | MegaRelationship>;
    unfollow(id: string): Promise<MastoRelationship | Endpoints['following/delete']['res'] | MegaRelationship>;
    block(id: string): Promise<MastoRelationship | Endpoints['blocking/create']['res'] | MegaRelationship>;
    unblock(id: string): Promise<MastoRelationship | Endpoints['blocking/delete']['res'] | MegaRelationship>;
    mute(id: string, opts: AccountMutePostDto): Promise<MastoRelationship>;
    unmute(id: string): Promise<MastoRelationship | MegaRelationship>;
    removeFollower(id: string): Promise<void>;
    featuredTags(id: string): Promise<MastoFeaturedTag[]>;
    knownFollowers(ids: string[]): Promise<MastoFamiliarFollowers[]>;
    getLists(id: string): PaginatedPromise<MastoList[]>;
    get(id: string): Promise<MastoAccount | MissUserDetailed | MegaAccount>;
    resolveMany(ids: string[]): Promise<MastoAccount[] | MissUserDetailed[]>;
    getPosts(id: string, query: AccountRouteStatusQueryDto): PaginatedPromise<MastoStatus[]>;
    relationships(ids: string[]): Promise<MastoRelationship[] | MegaRelationship[]>;
    likes(opts: GetPostsQueryDTO): PaginatedPromise<MastoStatus[] | MegaStatus[]>;
    bookmarks(query: BookmarkGetQueryDTO): Promise<{
        data: MastoStatus[] | Endpoints['i/favorites']['res'] | MegaStatus[];
        minId?: string | null;
        maxId?: string | null;
    }>;
    getFollowers(query: FollowerGetQueryDTO): PaginatedPromise<any>;
    getFollowings(query: FollowerGetQueryDTO): PaginatedPromise<any>;
}
export declare class DefaultAccountRouter extends BaseAccountsRouter {
}
//# sourceMappingURL=default.d.ts.map