import { getBskyAgent, getXrpcAgent } from '#/utils/atproto.js';
import { errorBuilder } from '#/types/index.js';
import { ApiErrorCode } from '#/types/api-response.js';
class BlueskyAccountsRouter {
    dto;
    constructor(dto) {
        this.dto = dto;
    }
    block(id) {
        return Promise.resolve(undefined);
    }
    async bookmarks(query) {
        const agent = getXrpcAgent(this.dto);
        const { data } = await agent.app.bsky.bookmark.getBookmarks({
            limit: query.limit,
            cursor: query.maxId,
        });
        return {
            data: data.bookmarks,
            maxId: data.cursor,
        };
    }
    async knownFollowers(ids) {
        throw new Error('Method not implemented. Please use accounts.get method,' +
            ' which includes the knownFollowers object ');
    }
    async featuredTags(id) {
        throw new Error('Method not available for driver');
    }
    async follow(id, opts) {
        const agent = getXrpcAgent(this.dto);
        return await agent.follow(id);
    }
    async getFollowers(query) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getFollowers({ actor: query.id });
        return {
            data: data.data.followers,
            maxId: data.data.cursor,
        };
    }
    async getFollowings(query) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getFollows({ actor: query.id });
        return {
            data: data.data.follows,
            maxId: data.data.cursor,
        };
    }
    async get(did) {
        const agent = getBskyAgent(this.dto);
        return agent.getProfile({ actor: did });
    }
    async getDid(handle) {
        const agent = getBskyAgent(this.dto);
        return agent.resolveHandle({ handle });
    }
    async resolveMany(ids) {
        throw new Error('Method not implemented.');
    }
    likes(query) {
        return errorBuilder(ApiErrorCode.FEATURE_UNSUPPORTED);
    }
    async atProtoLikes(actor, { limit, cursor, }) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getActorLikes({ actor, cursor, limit });
        return { data: data.data.feed, maxId: data.data.cursor };
    }
    async getLists(id) {
        const agent = getXrpcAgent(this.dto);
        const lists = await agent.app.bsky.graph.getLists({ actor: id });
        return {
            data: lists.data.lists,
            maxId: lists.data.cursor,
        };
    }
    lookup(webfinger) {
        throw new Error('Method not implemented.');
    }
    mute(id, opts) {
        throw new Error('Method not implemented.');
    }
    async relationships(ids) {
        throw new Error('Method not implemented.');
    }
    async removeFollower(id) {
        throw new Error('Method not implemented.');
    }
    async getPosts(id, params) {
        const agent = getBskyAgent(this.dto);
        const data = await agent.getAuthorFeed({
            actor: id,
            filter: params.bskyFilter,
            limit: params.limit,
            cursor: params.maxId === null ? undefined : params.maxId,
        });
        return { data: data.data.feed, maxId: data.data.cursor };
    }
    unblock(id) {
        return Promise.resolve(undefined);
    }
    async unfollow(id) {
        const agent = getXrpcAgent(this.dto);
        await agent.deleteFollow(id);
        return null;
    }
    unmute(id) {
        return Promise.resolve(undefined);
    }
    async getPinnedPosts(did) {
        const agent = getXrpcAgent(this.dto);
        try {
            const data = await agent.getAuthorFeed({
                includePins: true,
                actor: did,
                limit: 10,
            });
            return data.data.feed.filter((o) => o.reason && o.reason.$type === 'app.bsky.feed.defs#reasonPin');
        }
        catch (e) {
            return [];
        }
    }
}
export default BlueskyAccountsRouter;
//# sourceMappingURL=bluesky.js.map