import type { AppBskyActorDefs, AppBskyActorGetProfile, AppBskyBookmarkDefs, AppBskyFeedDefs, AppBskyGraphDefs, ComAtprotoIdentityResolveHandle } from '@atproto/api';
import { Endpoints } from 'misskey-js';
import type { MastoAccount, MastoFamiliarFollowers, MastoFeaturedTag, MastoRelationship } from '#/types/mastojs.types.js';
import { AccountRoute } from './_interface.js';
import { AccountMutePostDto, AccountRouteStatusQueryDto, BookmarkGetQueryDTO, FollowerGetQueryDTO, FollowPostDto, GetPostsQueryDTO } from '../../typings.js';
import { MegaRelationship } from '#/types/megalodon.types.js';
import { MissUserDetailed } from '#/types/misskey-js.types.js';
import { AppAtpSessionData } from '#/types/atproto.js';
import { FeedViewPost } from '@atproto/api/dist/client/types/app/bsky/feed/defs.js';
import { DriverWebfingerType } from '#/types/query.types.js';
import { PaginatedPromise } from '#/types/api-response.js';
declare class BlueskyAccountsRouter implements AccountRoute {
    dto: AppAtpSessionData;
    constructor(dto: AppAtpSessionData);
    block(id: string): Promise<Promise<MastoRelationship | Endpoints['blocking/create']['res'] | MegaRelationship>>;
    bookmarks(query: BookmarkGetQueryDTO): PaginatedPromise<AppBskyBookmarkDefs.BookmarkView[]>;
    knownFollowers(ids: string[]): Promise<MastoFamiliarFollowers[]>;
    featuredTags(id: string): Promise<MastoFeaturedTag[]>;
    follow(id: string, opts: FollowPostDto): Promise<{
        uri: string;
        cid: string;
    }>;
    getFollowers(query: FollowerGetQueryDTO): PaginatedPromise<AppBskyActorDefs.ProfileView[]>;
    getFollowings(query: FollowerGetQueryDTO): PaginatedPromise<AppBskyActorDefs.ProfileView[]>;
    get(did: string): Promise<AppBskyActorGetProfile.Response>;
    getDid(handle: string): Promise<ComAtprotoIdentityResolveHandle.Response>;
    resolveMany(ids: string[]): Promise<MastoAccount[] | MissUserDetailed[]>;
    likes(query: GetPostsQueryDTO): any;
    atProtoLikes(actor: string, { limit, cursor }: {
        limit: number;
        cursor: string | undefined;
    }): PaginatedPromise<AppBskyFeedDefs.FeedViewPost[]>;
    getLists(id: string): PaginatedPromise<AppBskyGraphDefs.ListView[]>;
    lookup(webfinger: DriverWebfingerType): Promise<MastoAccount>;
    mute(id: string, opts: AccountMutePostDto): Promise<MastoRelationship | MegaRelationship>;
    relationships(ids: string[]): Promise<MastoRelationship[] | MegaRelationship[]>;
    removeFollower(id: string): Promise<void>;
    getPosts(id: string, params: AccountRouteStatusQueryDto): PaginatedPromise<AppBskyFeedDefs.FeedViewPost[]>;
    unblock(id: string): Promise<Promise<MastoRelationship>>;
    unfollow(id: string): Promise<MastoRelationship | null>;
    unmute(id: string): Promise<Promise<MastoRelationship | MegaRelationship>>;
    getPinnedPosts(did: string): Promise<FeedViewPost[]>;
}
export default BlueskyAccountsRouter;
//# sourceMappingURL=bluesky.d.ts.map