import { RandomUtil } from '#/utils/index.js';
export const verifyMisskeyToken = async (host, session) => {
    const res = await fetch(`${host}/api/miauth/${session}/check`, {
        method: 'POST',
        headers: {},
    });
    if (!res.ok) {
        throw new Error(`Request failed: ${res.status} ${res.statusText}`);
    }
    const data = await res.json();
    return data;
};
const MISSKEY_PERMS = [
    'write:user-groups',
    'read:user-groups',
    'read:page-likes',
    'write:page-likes',
    'write:pages',
    'read:pages',
    'write:votes',
    'write:reactions',
    'read:reactions',
    'write:notifications',
    'read:notifications',
    'write:notes',
    'write:mutes',
    'read:mutes',
    'read:account',
    'write:account',
    'read:blocks',
    'write:blocks',
    'read:drive',
    'write:drive',
    'read:favorites',
    'write:favorites',
    'read:following',
    'write:following',
    'read:messaging',
    'write:messaging',
];
const MISSKEY_PERMS_POST_V12_47_0 = ['read:channels', 'write:channels'];
const MISSKEY_PERMS_POST_V12_75_0 = [
    'read:gallery',
    'write:gallery',
    'read:gallery-likes',
    'write:gallery-likes',
];
export function generateMiAuthUrl({ urlLike, appName, appCallback, }) {
    const uuid = RandomUtil.nanoId();
    const authEndpoint = `https://${urlLike}/miauth/${uuid}`;
    const perms = [
        ...MISSKEY_PERMS,
        ...MISSKEY_PERMS_POST_V12_75_0,
        ...MISSKEY_PERMS_POST_V12_47_0,
    ];
    const options = {
        name: appName,
        callback: appCallback, // https://example.com --> https://suvam.io
        permission: perms.join(','),
    };
    const queryString = Object.keys(options)
        .map((key) => `${key}=${encodeURIComponent(options[key])}`)
        .join('&');
    return `${authEndpoint}?${queryString}`;
}
//# sourceMappingURL=mi-auth.js.map